	% DEXample_13.2
	clear all
	close all
	clc
	 
	wcT = 0.4*pi;	 wsT = 0.402*pi;
%	wcT = 0.20*pi;	 wsT = 0.202*pi;
	dc = 0.01; Amax = H_2_MAG((1+dc)/(1-dc))
	ds = 0.001; Amin = H_2_MAG((1+dc)/ds)
	d = [dc, ds];
	% Conventional direct form
	[N, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT wsT],d); N
	% Determine the optimum M that minimize the filter complexity	
	M = round(1/sqrt(2*(wsT-wcT)/pi)), % beta = 1
	% Determine the Case, passband and stopband edge of the model and masking filters
	[Case, wcGT, wsGT, F1_EDGE, F2_EDGE] = FRM_CASE(wcT, wsT, M)	
	% Model filer
	if strcmp(Case,'Gc') 
		d = [dc/10, ds]/2; 		% We are using GcM and
	else
		d = [dc, ds]/2; 		% allow some design margin
	end
	[N_G, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcGT wsGT],d);
	N_G = N_G+mod(N_G,2) 	% Make sure that the FIR filter order is even
	[g, Err] = REMEZ_FIR(N_G, Be, D, W, 'm'); 
	% Masking filters
	[N_F0, Be, D, W] = HERRMANN_LP_FIR_ORDER([F1_EDGE(2) F1_EDGE(3)],d);  
	N_F0 = N_F0+mod(N_F0,2)			% Make sure that the filter order is even
	[f0, ErrF0] = REMEZ_FIR(N_F0, Be, D, W,'m'); ErrF0
	[N_F1, Be, D, W] = HERRMANN_LP_FIR_ORDER([F2_EDGE(2) F2_EDGE(3)],d); N_F1
	[f1, ErrF1] = REMEZ_FIR(N_F1, Be, D, W,'m'); ErrF1
	N_F1 = N_F1+mod(N_F1,2)
	f0 = [zeros(1,(N_F1-N_F0)/2) f0]; % Make the group delays of the filters equal 
	% Verify the frequency response of the FRM filter
	MwT = linspace(0, M*pi, 1000); wT = linspace(0, pi, 1000);
	GM = freqz(g,1,MwT);				% Periodic filter
	F0 = freqz(f0,1,wT);	 F1 = freqz(f1,1,wT);	
	figure(1), subplot(2,1,1)
	if strcmp(Case,'G') 		 
		PLOT_MAG_Z_dB(wT, GM, pi, 90, ' '), hold on
		PLOT_MAG_Z_dB(wT, F0, pi, 90, 'G_MF_0'), hold on
		PLOT_MAG_Z_dB(wT, F1, pi, 90, 'G_MF_1')
	else
		subplot(2,1,1) 
		PLOT_MAG_Z_dB(wT, (1-abs(GM)), pi, 90, ''), hold on
		PLOT_MAG_Z_dB(wT, F0, pi, 90, 'G_c_MF_0') 
		PLOT_MAG_Z_dB(wT, F1, pi, 90, 'G_c_MF_1')
	end
	figure(2), subplot(2,1,1) 
	PLOT_MAG_Z_dB(wT, abs(GM).*abs(F0), pi, 90, 'G_M F_0')
	subplot(2,1,2)
	PLOT_MAG_Z_dB(wT, (1-abs(GM)).*abs(F1), pi, 90, 'G_c_M F_1')
	figure(3),subplot(2,1,1) 
	PLOT_MAG_Z_dB(wT, abs(GM).*abs(F0)+(1-abs(GM)).*abs(F1),pi, 90, 'H')
 
